///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _ENTRY_CPP
#define _ENTRY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "Debug.H"
#include "Entry.H"
#include "Init.H"
#include "TrayIcon.H"
#include "TrayHandler.H"
#include "../../SharedClasses/CCmdLine/CCmdLine.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HINSTANCE ghAppInstance = NULL;

char gsAppCopyRight[64];
char gsFileVersion[32];
char gsTitleCaption[64];
char gsRegistryKey[64];
char gsServiceName[256];

char gsServiceControlExe[MAX_PATH];
char gsPath[MAX_PATH];

HANDLE hExitApplication = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD dwServiceThread_ID = 0;

HANDLE hServiceEventHandle = NULL;
HANDLE hServiceThread_Handle = NULL;

SERVICE_STATUS stServiceStatus;
SERVICE_STATUS_HANDLE sthServiceStatusHandler = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ExitThread(LPVOID lpVoid)
{
	WaitForSingleObject(hExitApplication, INFINITE);

	SendMessage(hTrayHandle, WM_COMMAND, ID_EXIT, 0);

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsServiceInstalled(void)
{
	SC_HANDLE hServiceControlHandle = NULL;
	SC_HANDLE hServiceHandle = NULL;

	if((hServiceControlHandle = OpenSCManager(NULL,  NULL, SC_MANAGER_CREATE_SERVICE)) == NULL)
	{
		MessageBox(NULL, "Error in IsServiceInstalled-OpenSCManager!", gsTitleCaption, MB_ICONERROR);
		return false;
	}

	if((hServiceHandle = OpenService(hServiceControlHandle, gsServiceName, SERVICE_INTERROGATE)) == NULL)
	{
		CloseServiceHandle(hServiceHandle);
		CloseServiceHandle(hServiceControlHandle);
		return false;
	}

	CloseServiceHandle(hServiceHandle);
	CloseServiceHandle(hServiceControlHandle);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsServiceActive(void)
{
	SC_HANDLE hServiceControlHandle = NULL;
	SC_HANDLE hServiceHandle = NULL;

	SERVICE_STATUS SvcStat;

	memset(&SvcStat, 0, sizeof(SvcStat));

	if((hServiceControlHandle = OpenSCManager(NULL,  NULL, SC_MANAGER_CREATE_SERVICE)) == NULL)
	{
		MessageBox(NULL, "Error in IsServiceActive-OpenSCManager!", gsTitleCaption, MB_ICONERROR);
		return false;
	}

	if((hServiceHandle = OpenService(hServiceControlHandle, gsServiceName, SERVICE_QUERY_STATUS)) == NULL)
	{
		CloseServiceHandle(hServiceHandle);
		CloseServiceHandle(hServiceControlHandle);
		return false;
	}

	if(!QueryServiceStatus(hServiceHandle, &SvcStat))
	{
		MessageBox(NULL, "Error in IsServiceActive-QueryServiceStatus!", gsTitleCaption, MB_ICONERROR);
		return false;
	}

	CloseServiceHandle(hServiceHandle);
	CloseServiceHandle(hServiceControlHandle);

	return (SvcStat.dwCurrentState == SERVICE_RUNNING);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool StopService(void)
{
	SERVICE_STATUS stLocalServiceStatus;
	SC_HANDLE hServiceControlHandle = NULL;
	SC_HANDLE hServiceHandle = NULL;

	// UnInstall The Service From Service Control Manager Database
	if((hServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE)) == NULL)
	{
		MessageBox( NULL, "Error in StopService-OpenSCManager!", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		return false;
	}

	if((hServiceHandle = OpenService(hServiceControlHandle, gsServiceName, SERVICE_ALL_ACCESS)) == NULL)
	{
		MessageBox( NULL, "Error in StopService-OpenService!", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		CloseServiceHandle(hServiceControlHandle);
		return false;
	}

	if(!ControlService(hServiceHandle, SERVICE_CONTROL_STOP, &stLocalServiceStatus))
	{
		MessageBox( NULL, "Error in StopService-ControlService!", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		CloseServiceHandle(hServiceHandle);
		CloseServiceHandle(hServiceControlHandle);
		return false;
	}

	CloseServiceHandle(hServiceHandle);
	CloseServiceHandle(hServiceControlHandle);

	return true;

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool StartService(void)
{
	SC_HANDLE hServiceControlHandle = NULL;
	SC_HANDLE hServiceHandle = NULL;

	// UnInstall The Service From Service Control Manager Database
	if((hServiceControlHandle = OpenSCManager(NULL, NULL, SC_MANAGER_CREATE_SERVICE)) == NULL)
	{
		MessageBox( NULL, "Error in StartService-OpenSCManager!", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		return false;
	}

	if((hServiceHandle = OpenService(hServiceControlHandle, gsServiceName, SERVICE_ALL_ACCESS)) == NULL)
	{
		MessageBox(NULL, "Error in StartService-OpenService!", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		CloseServiceHandle(hServiceControlHandle);
		return false;
	}

	if(!StartService(hServiceHandle, NULL, NULL))
	{
		MessageBox( NULL, "Error in StartService-StartService!", gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);
		CloseServiceHandle(hServiceHandle);
		CloseServiceHandle(hServiceControlHandle);
		return false;
	}

	CloseServiceHandle(hServiceHandle);
	CloseServiceHandle(hServiceControlHandle);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ServiceThread(LPVOID lpVoid)
{
	while(true)
	{
		while(!IsServiceInstalled())
		{
			UpdateTrayIcon(IDI_STOPPED, "Service is not installed");
			Sleep(5000);
		}

		while(IsServiceActive())
		{
			UpdateTrayIcon(IDI_RUNNING, "Service is active");
			Sleep(2500);
		}

		UpdateTrayIcon(IDI_STOPPED, "Service is inactive");

		Sleep(2500);
	}
	
	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *GetBuildMutexName(const char *sBase, int iMaxSz, char *sOutString)
{
	strcpy_s(sOutString, iMaxSz, sBase);

	#ifdef _X64_
		strcat_s(sOutString, iMaxSz, " x64");
	#elif _IA64_
		strcat_s(v, iMaxSz, " IA64");
	#else
		strcat_s(sOutString, iMaxSz, " x86");
	#endif

	return sOutString;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int TriggerEvent(char *sEventName)
{
	HANDLE hLocalEventHandle = NULL;
	bool bResult = false;

	if((hLocalEventHandle = OpenEvent(EVENT_MODIFY_STATE, FALSE, sEventName)) == NULL)
	{
        return false;
	}

    bResult = (SetEvent(hLocalEventHandle) == TRUE);

	CloseHandle(hLocalEventHandle);

	return bResult;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CreateExitEvent(void)
{
	SECURITY_DESCRIPTOR SD;
	SECURITY_ATTRIBUTES SA;

	InitializeSecurityDescriptor(&SD, SECURITY_DESCRIPTOR_REVISION);

	SetSecurityDescriptorDacl(&SD, TRUE, 0, FALSE);

	SA.nLength = sizeof(SA);
	SA.lpSecurityDescriptor = &SD;
	SA.bInheritHandle = FALSE;

	if((hExitApplication = CreateEvent( &SA, FALSE, FALSE, EXIT_APPLICATION_EVENT)) == NULL)
	{
        return false;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR sCmdLine, int iCmdShow)
{
    #ifdef _DEBUG
	ghAppInstance = GetModuleHandle(NULL);
    #else
	ghAppInstance = hInstance;
    #endif

	HANDLE hMutex = NULL;

    if(!InitializeApp())
    {
        return 1;
    }

	if(strlen(sCmdLine) == 0)
    {
        MessageBox(NULL, "No service name was specified.", gsTitleCaption, MB_ICONSTOP|MB_TASKMODAL);
        return false;
    }

	CCmdLine MyCmd;

	if(MyCmd.Alloc())
	{
		if(MyCmd.iCount != 2)
		{
			MyCmd.Free();
			MessageBox(NULL, "Incorrect number of command line parameters.", gsTitleCaption, MB_ICONSTOP|MB_TASKMODAL);
			return 0;
		}

		if(_strcmpi(MyCmd.sArray[1], "/Close") == 0)
		{
			MyCmd.Free();
			TriggerEvent(EXIT_APPLICATION_EVENT);
			return 0;
		}

		CreateExitEvent();

		strcpy_s(gsServiceName, sizeof(gsServiceName), MyCmd.sArray[1]);
	}
	else{
        MessageBox(NULL, "CCmdLine Alloc Failed!", gsTitleCaption, MB_ICONSTOP|MB_TASKMODAL);
		return 0;
	}

	MyCmd.Free();

	char sMutexName[1024];
	sprintf_s(sMutexName, sizeof(sMutexName), "%s_%s", gsTitleCaption, sCmdLine);
	if((hMutex = OpenMutex(SYNCHRONIZE, FALSE, sMutexName)))
	{
		MessageBox(NULL, "Only one instance can run at a time!", gsTitleCaption, MB_ICONASTERISK | MB_TASKMODAL);
		ReleaseMutex(hMutex);
		CloseHandle(hMutex);
		return 0;
	}
	else hMutex = CreateMutex(0, 0, GetBuildMutexName(gsTitleCaption, sizeof(sMutexName), sMutexName));

	HANDLE hExitThread = CreateThread(NULL, 0, ExitThread, (LPVOID) 0, 0, NULL);
	HANDLE hThread = CreateThread(NULL, 0, ServiceThread, (LPVOID) 0, 0, NULL);

	LoadTrayIcon(IDI_MAIN, gsTitleCaption);

	DestroyTrayIcon();

	CloseHandle(hExitThread);
	CloseHandle(hThread);

	if(!UninitializeApp())
    {
        return 1;
    }

	ReleaseMutex(hMutex);
	CloseHandle(hMutex);

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool MyExecute(char *sFile, char *sParameters)
{
    SHELLEXECUTEINFO seiExecuteInfo;

    memset(&seiExecuteInfo, 0, sizeof(seiExecuteInfo));
    
    seiExecuteInfo.cbSize       = sizeof(seiExecuteInfo);
    seiExecuteInfo.fMask        = 0;                
    seiExecuteInfo.hwnd         = 0;                
    seiExecuteInfo.lpVerb       = "open";
    seiExecuteInfo.lpFile       = sFile;
    seiExecuteInfo.lpParameters = sParameters;
    seiExecuteInfo.lpDirectory  = NULL;
    seiExecuteInfo.nShow        = SW_SHOW;
    seiExecuteInfo.hInstApp     = 0;
    
    if(ShellExecuteEx(&seiExecuteInfo))
        return true;
    else return false;

    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool RestartClientService(void)
{
    return MyExecute(gsServiceControlExe, "/Start");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Set_Text(HWND hWnd, char *sInBuf)
{
    SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sInBuf);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CenterWindow(HWND hWnd)
{
    RECT wRect;

    GetWindowRect(hWnd, &wRect);

    DWORD x = (GetSystemMetrics(SM_CXSCREEN)-(wRect.right-wRect.left))/2;
    DWORD y = (GetSystemMetrics(SM_CYSCREEN)-(wRect.bottom-wRect.top+GetSystemMetrics(SM_CYCAPTION)))/2;

    SetWindowPos(hWnd,NULL,x,y,0,0,SWP_NOSIZE|SWP_NOZORDER);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
